package com.agilex.healthcare.veteranappointment.domain;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public class VARPatientDataCollection<T extends PatientData> extends VARDomainTransferObjectCollection<T> {
	private static final long serialVersionUID = 1L;
	private PatientIdentifier patientIdentifier;

	@JsonCreator
	public VARPatientDataCollection(){
		super();
	}

	@JsonIgnore
	public PatientIdentifier getPatientIdentifier() {
		if (patientIdentifier == null)
			this.patientIdentifier = new PatientIdentifier();
		return patientIdentifier;
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setPatientId(String patientId) {
		getPatientIdentifier().setUniqueId(patientId);
	}

	public void updatePatientIdentifier(PatientIdentifier patientIdentifier) {
		this.setPatientIdentifier(patientIdentifier);
		for (PatientData data : this) {
			data.setPatientIdentifier(patientIdentifier);
		}
	}

	public void updateSystemId(String systemId) {
		for (PatientData data : this) {
			data.getDataIdentifier().setSystemId(systemId);
			
			if (systemId != null && data.getDataIdentifier().getUniqueId() == null && systemId.equalsIgnoreCase("vista")) {
				String uniqueId = UUID.randomUUID().toString();
				data.getDataIdentifier().setUniqueId(uniqueId);
			}
		}
	}

	public T findMatchById(DataIdentifier id) {
		T match = null;
		for (T potentialMatch : this) {
			if (potentialMatch.getDataIdentifier().equals(id))
				match = potentialMatch;
		}
		return match;
	}

	public T findMatchById(T patientData) {
		return findMatchById(patientData.getDataIdentifier());
	}

	

}
